/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.ai.goals.AllDirectionsTargetGoal;
import com.alexander.mutantmore.ai.goals.ApproachTargetGoal;
import com.alexander.mutantmore.ai.goals.LookAtTargetGoal;
import com.alexander.mutantmore.config.MutantMoreGroupedOptionsClientConfig;
import com.alexander.mutantmore.config.MutantMoreGroupedOptionsCommonConfig;
import com.alexander.mutantmore.config.MutantShulkerClientConfig;
import com.alexander.mutantmore.config.MutantShulkerCommonConfig;
import com.alexander.mutantmore.entities.MutantShulkerBullet;
import com.alexander.mutantmore.entities.MutantShulkerTrap;
import com.alexander.mutantmore.enums.CameraShakePriority;
import com.alexander.mutantmore.events.ShakeCameraEvent;
import com.alexander.mutantmore.init.DamageSourceInit;
import com.alexander.mutantmore.init.EntityTypeInit;
import com.alexander.mutantmore.init.MusicInit;
import com.alexander.mutantmore.init.ParticleTypeInit;
import com.alexander.mutantmore.init.SoundEventInit;
import com.alexander.mutantmore.init.TagInit;
import com.alexander.mutantmore.interfaces.IHasBossMusic;
import com.alexander.mutantmore.interfaces.IHasCustomExplosion;
import com.alexander.mutantmore.interfaces.IMutatable;
import com.alexander.mutantmore.interfaces.INaturallySpawningMutant;
import com.alexander.mutantmore.pathfinding.ImprovedMoveControl;
import com.alexander.mutantmore.util.BossMusicUtils;
import com.alexander.mutantmore.util.MiscUtils;
import com.google.common.collect.Lists;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.Control;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MutantShulker
extends Monster
implements IAnimatable,
IAnimationTickable,
IMutatable,
INaturallySpawningMutant,
IHasBossMusic,
IHasCustomExplosion {
    private static final EntityDataAccessor<Boolean> IN_BOX = SynchedEntityData.m_135353_(MutantShulker.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ANVIL_ATTACKING = SynchedEntityData.m_135353_(MutantShulker.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SPAWNED_IN_STRUCTURE = SynchedEntityData.m_135353_(MutantShulker.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TARGETED_ENTITY_ID = SynchedEntityData.m_135353_(MutantShulker.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int specialAnimationTick;
    public final int specialAnimationLength = 45;
    public int introAnimationTick;
    public final int introAnimationLength = 45;
    public int shootAnimationTick;
    public int shootAnimationLength = 45;
    public int shootAnimationActionPoint1 = 25;
    public int shootAnimationActionPoint2 = 15;
    public int shootAnimationActionPoint3 = 10;
    public int biteAnimationTick;
    public int biteAnimationLength = 55;
    public int biteAnimationActionPoint = 38;
    public int prepareFlyAnimationTick;
    public int prepareFlyAnimationLength = 21;
    public int prepareFlyActionPoint = 8;
    public boolean flying = false;
    public int summonTrapsAnimationTick;
    public int summonTrapsAnimationLength = 50;
    public int specialAnimationTickInShell;
    public int specialAnimationLengthInShell = 50;
    public int shootAnimationTickInShell;
    public int shootAnimationLengthInShell = 47;
    public int shootAnimationActionPointInShell = 20;
    public int summonTrapsAnimationTickInShell;
    public int summonTrapsAnimationLengthInShell = 50;
    public int anvilCrushAnimationTick;
    public int anvilCrushAnimationLength = 43;
    public int anvilCrushAnimationActionPoint = 28;
    public float healthHealedInShell = 0.0f;
    public int anvilCrushSoundCooldown = 0;
    public int nextEnterShellTime;
    public DamageSource killedBy;
    public List<LivingEntity> alreadyCrushed = Lists.newArrayList();
    public static EntityDimensions inBoxDimensions = EntityDimensions.m_20395_((float)1.9f, (float)1.9f);
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.NOTCHED_12).m_7003_(true);
    private int destroyBlocksTick;

    public MutantShulker(EntityType<? extends MutantShulker> p_i50189_1_, Level p_i50189_2_) {
        super(p_i50189_1_, p_i50189_2_);
        this.f_21342_ = new ImprovedMoveControl((Mob)this, 90.0f, 7);
        this.f_21364_ = (Integer)MutantShulkerCommonConfig.exp_reward.get();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new RemainStationaryGoal());
        if (((Boolean)MutantShulkerCommonConfig.enters_shell.get()).booleanValue()) {
            this.f_21345_.m_25352_(0, (Goal)new EnterShellGoal());
        }
        if (((Boolean)MutantShulkerCommonConfig.leaves_shell.get()).booleanValue()) {
            this.f_21345_.m_25352_(0, (Goal)new LeaveShellGoal());
        }
        if (((Boolean)MutantShulkerCommonConfig.uses_fly.get()).booleanValue()) {
            this.f_21345_.m_25352_(1, (Goal)new FlyGoal(this));
        }
        if (((Boolean)MutantShulkerCommonConfig.uses_anvil_crush.get()).booleanValue()) {
            this.f_21345_.m_25352_(1, (Goal)new AnvilCrushAttackGoal(this));
        }
        if (((Boolean)MutantShulkerCommonConfig.uses_scatter_traps.get()).booleanValue()) {
            this.f_21345_.m_25352_(2, (Goal)new ScatterTrapsAttackGoal(this));
        }
        if (((Boolean)MutantShulkerCommonConfig.uses_scatter_traps_in_shell.get()).booleanValue()) {
            this.f_21345_.m_25352_(2, (Goal)new ScatterTrapsAttackInShellGoal(this));
        }
        if (((Boolean)MutantShulkerCommonConfig.uses_bite.get()).booleanValue()) {
            this.f_21345_.m_25352_(3, (Goal)new BiteAttackGoal(this));
        }
        if (((Boolean)MutantShulkerCommonConfig.uses_shoot.get()).booleanValue()) {
            this.f_21345_.m_25352_(4, (Goal)new ShootAttackGoal(this));
        }
        if (((Boolean)MutantShulkerCommonConfig.uses_shoot_in_shell.get()).booleanValue()) {
            this.f_21345_.m_25352_(4, (Goal)new ShootAttackGoalInShell(this));
        }
        this.f_21345_.m_25352_(6, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new ApproachTargetGoal((PathfinderMob)this, (Double)MutantShulkerCommonConfig.follow_target_wanted_distance.get(), (Double)MutantShulkerCommonConfig.following_movement_speed_multiplier.get(), true){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !MutantShulker.this.isInBox();
            }

            @Override
            public boolean m_8045_() {
                return super.m_8045_() && !MutantShulker.this.isInBox();
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 7.5f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean m_8036_() {
                return super.m_8036_() && !MutantShulker.this.isInBox();
            }

            public boolean m_8045_() {
                return super.m_8045_() && !MutantShulker.this.isInBox();
            }
        });
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26146_(6000));
        if (((Boolean)MutantShulkerCommonConfig.attacks_players.get()).booleanValue() && !((Boolean)MutantMoreGroupedOptionsCommonConfig.mutants_attack_players_off.get()).booleanValue()) {
            this.f_21346_.m_25352_(1, (Goal)new AllDirectionsTargetGoal<Player>((Mob)this, Player.class, true).m_26146_(6000));
        }
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 20, false, false, entity -> entity.m_6095_().m_204039_(TagInit.EntityTypes.MUTANT_SHULKER_TARGETS)){

            protected AABB m_7255_(double p_26069_) {
                return this.f_26135_.m_20191_().m_82377_(((Double)MutantShulkerCommonConfig.follow_non_player_distance.get()).doubleValue(), ((Double)MutantShulkerCommonConfig.follow_non_player_distance.get()).doubleValue(), ((Double)MutantShulkerCommonConfig.follow_non_player_distance.get()).doubleValue());
            }
        });
    }

    @Override
    public boolean canHarmWithExplosion(Entity target) {
        return this.canHarm(target);
    }

    boolean canHarm(Entity target) {
        return MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_SHULKER_CANT_HURT, (Entity)this, target, (Entity)this, null);
    }

    public float getStepHeight() {
        return 1.6f;
    }

    protected PathNavigation m_6037_(Level p_33348_) {
        return new MutantShulkerNavigation((Mob)this, p_33348_);
    }

    protected BodyRotationControl m_7560_() {
        return new MutantShulkerBodyRotationControl((Mob)this);
    }

    public boolean shouldBodyMoveWithHead() {
        return this.biteAnimationTick > 0 || this.introAnimationTick > 0;
    }

    public int m_8085_() {
        return Integer.MAX_VALUE;
    }

    public int m_8132_() {
        return Integer.MAX_VALUE;
    }

    public boolean shouldBeStationary() {
        return this.introAnimationTick > 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22279_, 0.275).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 5.0);
    }

    public void setConfigurableAttributeValues() {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)MutantShulkerCommonConfig.max_health.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)MutantShulkerCommonConfig.armour.get()).doubleValue());
        this.m_21051_(Attributes.f_22285_).m_22100_(((Double)MutantShulkerCommonConfig.armour_toughness.get()).doubleValue());
        this.m_21051_(Attributes.f_22278_).m_22100_(((Double)MutantShulkerCommonConfig.knockback_resistance.get()).doubleValue());
        this.m_21051_(Attributes.f_22277_).m_22100_(((Double)MutantShulkerCommonConfig.follow_player_distance.get()).doubleValue());
        this.m_21051_(Attributes.f_22279_).m_22100_(((Double)MutantShulkerCommonConfig.movement_speed.get()).doubleValue());
        this.m_21153_(this.m_21233_());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, SpawnGroupData p_21437_, CompoundTag p_21438_) {
        this.setConfigurableAttributeValues();
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    public boolean m_21481_(BlockPathTypes p_21482_) {
        return true;
    }

    public boolean m_6779_(LivingEntity target) {
        return this.canTarget((Entity)target) && super.m_6779_(target);
    }

    boolean canTarget(Entity target) {
        return MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_SHULKER_CANT_TARGET, (Entity)this, target, (Entity)this, null);
    }

    protected SoundEvent m_7515_() {
        return this.isInBox() ? null : (SoundEvent)SoundEventInit.MUTANT_SHULKER_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)SoundEventInit.MUTANT_SHULKER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    public float m_6100_() {
        return this.m_21224_() ? 1.0f : super.m_6100_();
    }

    protected float m_6121_() {
        return this.m_21224_() ? 3.0f : super.m_6121_();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        if (!this.flying) {
            this.m_5496_((SoundEvent)SoundEventInit.MUTANT_SHULKER_STEP.get(), 0.5f, 1.0f);
        }
    }

    public EntityDimensions m_6972_(Pose p_19975_) {
        return this.isInBox() ? inBoxDimensions : super.m_6972_(p_19975_);
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (source != null && source == DamageSource.f_19317_) {
            this.m_5496_(SoundEvents.f_12038_, this.m_6121_(), this.m_6100_());
        } else {
            this.m_5496_((SoundEvent)SoundEventInit.MUTANT_SHULKER_DEATH.get(), this.m_6121_(), 1.0f);
        }
        this.killedBy = source;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.m_21225_() != null && this.m_21225_() == DamageSource.f_19317_) {
            if (this.f_20919_ == 20 && !this.f_19853_.m_5776_()) {
                this.f_19853_.m_7605_((Entity)this, (byte)60);
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        } else {
            int i;
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
            if (!this.f_19853_.f_46443_ && this.f_20919_ > 20 && this.f_20919_ < 90 && this.f_20919_ % 2 == 0) {
                for (i = 0; i < 2; ++i) {
                    this.shootMutantShulkerProjectile(this.f_19796_.m_188503_(360), new BlockPos(this.m_20185_() - 50.0 + (double)this.f_19796_.m_188503_(100), this.m_20186_() + 2.0 + (double)this.f_19796_.m_188503_(20), this.m_20189_() - 50.0 + (double)this.f_19796_.m_188503_(100)), false);
                }
            }
            if (this.f_20919_ == 113) {
                ShakeCameraEvent.shake(this.f_19853_, 80, 0.03f, this.m_20183_(), 25, CameraShakePriority.STRONG_MOB_ACTION);
                if (!this.f_19853_.f_46443_) {
                    MiscUtils.customExplosion(this.f_19853_, (Entity)this, DamageSource.m_19373_((LivingEntity)this), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 15.0f, false, this.deathExplosionBlockInteraction(), null, this.m_5720_(), (ParticleOptions)ParticleTypes.f_123813_, (ParticleOptions)ParticleTypes.f_123812_, ((Double)MutantShulkerCommonConfig.death_explosion_damage.get()).floatValue(), true, true);
                }
            }
            if (this.f_20919_ == 123) {
                if (!this.f_19853_.f_46443_) {
                    if (this.killedBy != null) {
                        this.dropAllTickDeathLoot(this.killedBy);
                    }
                    this.m_142687_(Entity.RemovalReason.KILLED);
                }
                for (i = 0; i < 20; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
                }
            }
        }
    }

    public Explosion.BlockInteraction deathExplosionBlockInteraction() {
        if (((Boolean)MutantShulkerCommonConfig.death_griefing.get()).booleanValue()) {
            if (((Boolean)MutantShulkerCommonConfig.death_griefing_drops_blocks.get()).booleanValue()) {
                return Explosion.BlockInteraction.BREAK;
            }
            return Explosion.BlockInteraction.DESTROY;
        }
        return Explosion.BlockInteraction.NONE;
    }

    protected void m_6668_(DamageSource source) {
    }

    public void dropAllTickDeathLoot(DamageSource source) {
        Entity entity = source.m_7639_();
        int i = ForgeHooks.getLootingLevel((Entity)this, (Entity)entity, (DamageSource)source);
        this.captureDrops(new ArrayList());
        boolean flag = this.f_20889_ > 0;
        this.m_7625_(source, flag);
        this.m_7472_(source, i, flag);
        this.m_5907_();
        this.m_21226_();
        Collection drops = this.captureDrops(null);
        if (!ForgeHooks.onLivingDrops((LivingEntity)this, (DamageSource)source, (Collection)drops, (int)i, (this.f_20889_ > 0 ? 1 : 0) != 0)) {
            drops.forEach(e -> this.f_19853_.m_7967_((Entity)e));
        }
    }

    public ItemEntity m_5552_(ItemStack p_19985_, float p_19986_) {
        if (p_19985_.m_41619_()) {
            return null;
        }
        if (this.f_19853_.f_46443_) {
            return null;
        }
        ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_() + (double)p_19986_, this.m_20189_(), p_19985_);
        itementity.m_32060_();
        itementity.m_32064_();
        if (this.captureDrops() != null) {
            this.captureDrops().add(itementity);
        } else {
            this.f_19853_.m_7967_((Entity)itementity);
        }
        return itementity;
    }

    public boolean inBoxButOpen() {
        return this.isInBox() && (this.summonTrapsAnimationTickInShell > 0 || this.specialAnimationTickInShell > 0 || this.shootAnimationTickInShell > 0 || this.anvilCrushAnimationTick > 0);
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (p_21016_.m_7640_() instanceof ShulkerBullet) {
            return false;
        }
        if (this.isInBox() && !this.inBoxButOpen() && p_21016_ != DamageSource.f_19317_) {
            this.m_5496_(SoundEvents.f_12415_, 1.0f, 0.5f);
            return false;
        }
        if (!super.m_6469_(p_21016_, p_21017_)) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && ((Boolean)MutantShulkerCommonConfig.teleports_when_hit.get()).booleanValue() && this.f_19796_.m_188503_(((Integer)MutantShulkerCommonConfig.teleport_when_hit_chance.get()).intValue()) == 0 && p_21016_ != DamageSource.f_19317_) {
            if (!this.f_19853_.f_46443_ && this.m_5448_() != null) {
                this.teleport();
            } else if (!this.f_19853_.f_46443_ && this.m_5448_() == null) {
                this.teleport();
            }
            return false;
        }
        if (this.flying && ((Boolean)MutantShulkerCommonConfig.getting_hit_cancels_flying.get()).booleanValue() && this.f_19797_ >= this.nextEnterShellTime) {
            this.flying = false;
            this.setInBox(true);
            this.f_19853_.m_7605_((Entity)this, (byte)6);
        }
        if (!this.m_6673_(p_21016_) && this.destroyBlocksTick <= 0) {
            this.destroyBlocksTick = 20;
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    protected float m_6431_(Pose p_34186_, EntityDimensions p_34187_) {
        return this.isInBox() ? 1.0f : 1.8f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IN_BOX, (Object)false);
        this.f_19804_.m_135372_(SPAWNED_IN_STRUCTURE, (Object)false);
        this.f_19804_.m_135372_(ANVIL_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(TARGETED_ENTITY_ID, (Object)0);
    }

    public int getTargetedEntityID() {
        return (Integer)this.f_19804_.m_135370_(TARGETED_ENTITY_ID);
    }

    public void setTargetedEntityID(int setTo) {
        this.f_19804_.m_135381_(TARGETED_ENTITY_ID, (Object)setTo);
    }

    public void m_7380_(CompoundTag p_29495_) {
        super.m_7380_(p_29495_);
        p_29495_.m_128379_("InBox", this.isInBox());
        p_29495_.m_128379_("SpawnedInStructure", this.isSpawnedInStructure());
    }

    public void m_7378_(CompoundTag p_29478_) {
        super.m_7378_(p_29478_);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.setInBox(p_29478_.m_128471_("InBox"));
        this.setSpawnedInStructure(p_29478_.m_128471_("SpawnedInStructure"));
    }

    public void m_6593_(@Nullable Component p_31476_) {
        super.m_6593_(p_31476_);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public boolean isInBox() {
        return (Boolean)this.m_20088_().m_135370_(IN_BOX);
    }

    public void setInBox(boolean inBox) {
        if (inBox) {
            this.healthHealedInShell = 0.0f;
        }
        this.m_20088_().m_135381_(IN_BOX, (Object)inBox);
    }

    public boolean isSpawnedInStructure() {
        return (Boolean)this.m_20088_().m_135370_(SPAWNED_IN_STRUCTURE);
    }

    public void setSpawnedInStructure(boolean inBox) {
        this.m_20088_().m_135381_(SPAWNED_IN_STRUCTURE, (Object)inBox);
    }

    public boolean isAnvilAttacking() {
        return (Boolean)this.m_20088_().m_135370_(ANVIL_ATTACKING);
    }

    public void setAnvilAttacking(boolean inBox) {
        this.m_20088_().m_135381_(ANVIL_ATTACKING, (Object)inBox);
    }

    protected void m_8024_() {
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.destroyBlocksTick > 0) {
            --this.destroyBlocksTick;
            if (this.destroyBlocksTick == 0 && ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
                int j1 = Mth.m_14107_((double)this.m_20186_());
                int i2 = Mth.m_14107_((double)this.m_20185_());
                int j2 = Mth.m_14107_((double)this.m_20189_());
                boolean flag = false;
                AABB aabb = this.m_20191_().m_82377_(0.5, 0.0, 0.5);
                for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                    BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                    Block block = blockstate.m_60734_();
                    if (blockstate.m_204336_(TagInit.Blocks.UNBREAKABLE)) continue;
                    flag = this.f_19853_.m_46953_(blockpos, (Boolean)MutantShulkerCommonConfig.hurt_griefing_drops_blocks.get() != false || (Boolean)MutantMoreGroupedOptionsCommonConfig.griefing_drops_blocks_on.get() != false, (Entity)this) || flag;
                }
                if (flag) {
                    this.f_19853_.m_5898_((Player)null, 1022, this.m_20183_(), 0);
                }
            }
        }
        super.m_8024_();
    }

    public void m_6452_(ServerPlayer p_31488_) {
        super.m_6452_(p_31488_);
        this.bossEvent.m_6539_(p_31488_);
    }

    public void m_8107_() {
        super.m_8107_();
        for (Entity entity : this.f_19853_.m_45933_((Entity)this, this.m_20191_())) {
            if (!this.canHarm(entity)) continue;
            if (this.flying) {
                ShakeCameraEvent.shake(this.f_19853_, 30, 0.015f, this.m_20183_(), 5, CameraShakePriority.WEAK_MOB_ACTION);
                double d0 = entity.m_20185_() - this.m_20185_();
                double d1 = entity.m_20189_() - this.m_20189_();
                double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                entity.m_5997_(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
                entity.m_6469_(DamageSourceInit.mutantShulkerFlightAttack((LivingEntity)this), ((Double)MutantShulkerCommonConfig.fly_damage.get()).floatValue());
            }
            if (!this.isAnvilAttacking() || this.alreadyCrushed.contains(entity)) continue;
            if (entity instanceof LivingEntity) {
                this.alreadyCrushed.add((LivingEntity)entity);
                if (((Boolean)MutantShulkerCommonConfig.ignores_invulnerability_time.get()).booleanValue()) {
                    ((LivingEntity)entity).f_19802_ = 0;
                }
            }
            ShakeCameraEvent.shake(this.f_19853_, 30, 0.015f, this.m_20183_(), 5, CameraShakePriority.STRONG_MOB_ACTION);
            if (this.anvilCrushSoundCooldown <= 0) {
                this.m_5496_((SoundEvent)SoundEventInit.MUTANT_SHULKER_ANVIL_CRUSH.get(), 1.0f, 1.0f);
                this.anvilCrushSoundCooldown = 40;
            }
            entity.m_6469_(DamageSourceInit.mutantShulkerAnvilCrushAttack((LivingEntity)this), ((Double)MutantShulkerCommonConfig.anvil_crush_damage.get()).floatValue());
        }
        if (this.f_19862_ && ((Boolean)MutantShulkerCommonConfig.walk_griefing.get()).booleanValue() && !((Boolean)MutantMoreGroupedOptionsCommonConfig.mob_griefing_off.get()).booleanValue()) {
            boolean flag = false;
            AABB aabb = this.m_20191_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (!blockstate.m_204336_(TagInit.Blocks.MUTANT_SHULKER_WALKS_THROUGH)) continue;
                flag = this.f_19853_.m_46953_(blockpos, (Boolean)MutantShulkerCommonConfig.walk_griefing_drops_blocks.get() != false || (Boolean)MutantMoreGroupedOptionsCommonConfig.griefing_drops_blocks_on.get() != false, (Entity)this) || flag;
            }
        }
        if (!this.f_19853_.f_46443_ && this.f_19797_ % 10 == 0 && this.flying && ((Boolean)MutantShulkerCommonConfig.flight_griefing.get()).booleanValue() && !((Boolean)MutantMoreGroupedOptionsCommonConfig.mob_griefing_off.get()).booleanValue()) {
            int j1 = Mth.m_14107_((double)this.m_20186_());
            int i2 = Mth.m_14107_((double)this.m_20185_());
            int j2 = Mth.m_14107_((double)this.m_20189_());
            boolean flag = false;
            for (int j = -2; j <= 2; ++j) {
                for (int k2 = -2; k2 <= 2; ++k2) {
                    for (int k = 0; k <= 3; ++k) {
                        int l2 = i2 + j;
                        int l = j1 + k;
                        int i1 = j2 + k2;
                        BlockPos blockpos = new BlockPos(l2, l, i1);
                        BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                        if (blockstate.m_204336_(TagInit.Blocks.UNBREAKABLE)) continue;
                        flag = this.f_19853_.m_46953_(blockpos, (Boolean)MutantShulkerCommonConfig.flight_griefing_drops_blocks.get() != false || (Boolean)MutantMoreGroupedOptionsCommonConfig.griefing_drops_blocks_on.get() != false, (Entity)this) || flag;
                    }
                }
            }
            if (flag) {
                this.f_19853_.m_5898_((Player)null, 1022, this.m_20183_(), 0);
            }
        }
        if (!this.f_19853_.f_46443_ && ((Boolean)MutantShulkerCommonConfig.teleports_to_avoid_falling_into_the_void.get()).booleanValue() && this.m_5448_() != null && this.isFallingToDoom() && !this.isAnvilAttacking()) {
            this.teleportTowards((Entity)this.m_5448_());
        }
        if (this.m_20069_() && ((Boolean)MutantShulkerCommonConfig.teleports_in_water.get()).booleanValue()) {
            this.teleport();
        }
        if (!this.f_19853_.f_46443_ && this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) > 5.0f && this.f_19796_.m_188503_(((Integer)MutantShulkerCommonConfig.basic_teleport_chance.get()).intValue()) == 0 && !this.m_21224_() && !this.isAnvilAttacking()) {
            if (this.flying && ((Boolean)MutantShulkerCommonConfig.teleports_while_flying.get()).booleanValue() || this.isInBox() && ((Boolean)MutantShulkerCommonConfig.teleports_while_in_shell.get()).booleanValue()) {
                this.teleport(this.m_5448_().m_20185_() - 15.0 + (double)this.f_19796_.m_188503_(30), this.m_20186_(), this.m_5448_().m_20189_() - 15.0 + (double)this.f_19796_.m_188503_(30));
            } else if (((Boolean)MutantShulkerCommonConfig.teleports_to_follow_target.get()).booleanValue()) {
                this.teleportTowards((Entity)this.m_5448_());
            }
        }
    }

    boolean isFallingToDoom() {
        boolean blockBeneath = false;
        for (int i = 0; i < 64; ++i) {
            if (this.f_19853_.m_8055_(new BlockPos(this.m_20183_().m_123341_(), this.m_20183_().m_123342_() - i, this.m_20183_().m_123343_())).m_60795_()) continue;
            blockBeneath = true;
        }
        return !this.f_19853_.f_46443_ && !blockBeneath;
    }

    public void m_6075_() {
        super.m_6075_();
        if (!this.f_19853_.f_46443_ && this.f_201939_ && this.isAnvilAttacking()) {
            ShakeCameraEvent.shake(this.f_19853_, 20, 0.01f, this.m_20183_(), 10, CameraShakePriority.EFFECT);
            this.m_5496_((SoundEvent)SoundEventInit.MUTANT_SHULKER_ANVIL_CRUSH.get(), 1.0f, 1.0f);
            this.alreadyCrushed.clear();
            this.setAnvilAttacking(false);
        }
        this.m_6210_();
        if (!this.f_19853_.f_46443_) {
            if (this.m_5448_() != null && !this.m_5448_().m_213877_()) {
                this.setTargetedEntityID(this.m_5448_().m_19879_());
            } else {
                this.setTargetedEntityID(0);
            }
        }
        if (!this.f_19853_.f_46443_ && this.isSpawnedInStructure()) {
            this.onMutantSpawned(MobSpawnType.STRUCTURE);
            this.setSpawnedInStructure(false);
        }
        if (!this.f_19853_.f_46443_ && (this.isInBox() || this.m_21224_())) {
            this.m_21573_().m_26573_();
        }
        if (!this.f_19853_.f_46443_ && this.isInBox() && this.f_19797_ % (Integer)MutantShulkerCommonConfig.shell_heal_interval.get() == 0 && this.m_21223_() < this.m_21233_()) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)((SimpleParticleType)ParticleTypeInit.MUTANT_SHULKER_HEAL.get()), this.m_20208_(1.25), this.m_20187_(), this.m_20262_(1.25), 1, 0.1, 0.1, 0.1, 0.0);
            this.m_5634_(((Double)MutantShulkerCommonConfig.shell_heal_amount.get()).floatValue());
            this.healthHealedInShell += ((Double)MutantShulkerCommonConfig.shell_heal_amount.get()).floatValue();
        }
        if (((Boolean)MutantShulkerClientConfig.show_health_bar.get()).booleanValue() || ((Boolean)MutantMoreGroupedOptionsClientConfig.show_health_bars_on.get()).booleanValue()) {
            if (this.m_5448_() != null && this.m_6084_()) {
                if (this.m_5448_() instanceof ServerPlayer) {
                    this.bossEvent.m_6543_((ServerPlayer)this.m_5448_());
                }
                for (ServerPlayer player : this.f_19853_.m_6443_(ServerPlayer.class, this.m_20191_().m_82400_(20.0), MiscUtils.ALIVE)) {
                    this.bossEvent.m_6543_(player);
                }
            } else if (this.m_5448_() == null || !this.m_6084_()) {
                for (ServerPlayer player : this.f_19853_.m_6443_(ServerPlayer.class, this.m_20191_().m_82400_(75.0), MiscUtils.ALIVE)) {
                    this.bossEvent.m_6539_(player);
                }
            }
        }
        Vec3 velocity = this.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        if (!this.f_19853_.f_46443_ && groundSpeed <= 0.1f && this.specialAnimationTick <= 0 && this.f_19796_.m_188503_(400) == 0 && (this.m_5448_() == null || this.m_5448_().m_21224_() || this.m_5448_().m_213877_())) {
            if (this.isInBox()) {
                this.m_5496_((SoundEvent)SoundEventInit.MUTANT_SHULKER_OPEN.get(), 1.0f, 1.0f);
                this.specialAnimationTickInShell = this.specialAnimationLengthInShell;
                this.f_19853_.m_7605_((Entity)this, (byte)36);
            } else {
                this.m_5496_((SoundEvent)SoundEventInit.MUTANT_SHULKER_ROAR.get(), 1.0f, 1.0f);
                Objects.requireNonNull(this);
                this.specialAnimationTick = 45;
                this.f_19853_.m_7605_((Entity)this, (byte)4);
            }
        }
        if (this.specialAnimationTickInShell == 20 && groundSpeed <= 0.1f && (this.m_5448_() == null || this.m_5448_().m_21224_() || this.m_5448_().m_213877_())) {
            this.m_5496_((SoundEvent)SoundEventInit.MUTANT_SHULKER_CLOSE.get(), 1.0f, 1.0f);
        }
        if (this.flying) {
            this.m_20242_(true);
        } else {
            this.m_20242_(false);
        }
        if (this.anvilCrushSoundCooldown > 0) {
            --this.anvilCrushSoundCooldown;
        }
        this.tickDownAnimTimers();
    }

    public void shootMutantShulkerProjectile(float angle, BlockPos shootToPos, boolean aimForTarget) {
        if (aimForTarget && this.m_5448_() != null) {
            MutantShulkerBullet projectile = new MutantShulkerBullet((EntityType<? extends MutantShulkerBullet>)((EntityType)EntityTypeInit.MUTANT_SHULKER_BULLET.get()), this.f_19853_);
            projectile.damage = ((Double)MutantShulkerCommonConfig.mutant_shulker_bullet_damage.get()).floatValue();
            projectile.griefing = (Boolean)MutantShulkerCommonConfig.mutant_shulker_bullet_griefing.get() != false && (Boolean)MutantMoreGroupedOptionsCommonConfig.mob_griefing_off.get() == false;
            projectile.griefingDropsBlocks = (Boolean)MutantShulkerCommonConfig.mutant_shulker_bullet_griefing_drops_blocks.get() != false || (Boolean)MutantMoreGroupedOptionsCommonConfig.griefing_drops_blocks_on.get() != false;
            projectile.explosionSize = ((Double)MutantShulkerCommonConfig.mutant_shulker_bullet_explosion_size.get()).floatValue();
            projectile.levitationLength = (Integer)MutantShulkerCommonConfig.mutant_shulker_bullet_levitation_length.get();
            projectile.levitationLevel = (Integer)MutantShulkerCommonConfig.mutant_shulker_bullet_levitation_level.get();
            projectile.ignoresInvulTime = (Boolean)MutantShulkerCommonConfig.ignores_invulnerability_time.get();
            projectile.setRemainingHits((Integer)MutantShulkerCommonConfig.mutant_shulker_bullet_hits.get());
            projectile.m_6034_(this.m_20185_(), this.m_20188_(), this.m_20189_());
            projectile.setTargetByID(this.m_5448_().m_19879_());
            projectile.m_5602_((Entity)this);
            this.shootMutantShulkerProjectile(this.m_5448_().m_20183_(), projectile, angle);
            this.f_19853_.m_7967_((Entity)projectile);
        } else {
            MutantShulkerBullet projectile = new MutantShulkerBullet((EntityType<? extends MutantShulkerBullet>)((EntityType)EntityTypeInit.MUTANT_SHULKER_BULLET.get()), this.f_19853_);
            projectile.damage = ((Double)MutantShulkerCommonConfig.mutant_shulker_bullet_damage.get()).floatValue();
            projectile.griefing = (Boolean)MutantShulkerCommonConfig.mutant_shulker_bullet_griefing.get() != false && (Boolean)MutantMoreGroupedOptionsCommonConfig.mob_griefing_off.get() == false;
            projectile.griefingDropsBlocks = (Boolean)MutantShulkerCommonConfig.mutant_shulker_bullet_griefing_drops_blocks.get() != false || (Boolean)MutantMoreGroupedOptionsCommonConfig.griefing_drops_blocks_on.get() != false;
            projectile.explosionSize = ((Double)MutantShulkerCommonConfig.mutant_shulker_bullet_explosion_size.get()).floatValue();
            projectile.levitationLength = (Integer)MutantShulkerCommonConfig.mutant_shulker_bullet_levitation_length.get();
            projectile.levitationLevel = (Integer)MutantShulkerCommonConfig.mutant_shulker_bullet_levitation_level.get();
            projectile.ignoresInvulTime = (Boolean)MutantShulkerCommonConfig.ignores_invulnerability_time.get();
            projectile.setRemainingHits((Integer)MutantShulkerCommonConfig.mutant_shulker_bullet_hits.get());
            projectile.m_6034_(this.m_20185_(), this.m_20188_(), this.m_20189_());
            projectile.m_5602_((Entity)this);
            this.shootMutantShulkerProjectile(shootToPos, projectile, angle);
            this.f_19853_.m_7967_((Entity)projectile);
        }
    }

    public void shootMutantShulkerProjectile(BlockPos p_33275_, Projectile p_33277_, float p_33278_) {
        this.shootMutantShulkerProjectile((LivingEntity)this, p_33275_, p_33277_, p_33278_, 1.0f);
    }

    public void shootMutantShulkerProjectile(LivingEntity p_32323_, BlockPos p_32324_, Projectile p_32325_, float p_32326_, float p_32327_) {
        double d0 = (double)p_32324_.m_123341_() - p_32323_.m_20185_();
        double d1 = (double)p_32324_.m_123343_() - p_32323_.m_20189_();
        double d2 = Math.sqrt(d0 * d0 + d1 * d1);
        double d3 = (double)p_32324_.m_123342_() - p_32325_.m_20186_() + d2 * (double)0.2f;
        Vector3f vector3f = this.getProjectileShotVector(p_32323_, new Vec3(d0, d3, d1), p_32326_);
        p_32325_.m_6686_((double)vector3f.m_122239_(), (double)vector3f.m_122260_(), (double)vector3f.m_122269_(), p_32327_, (float)(14 - p_32323_.f_19853_.m_46791_().m_19028_() * 4));
        p_32323_.m_5496_((SoundEvent)SoundEventInit.MUTANT_SHULKER_SHOOT.get(), 2.0f, 1.0f / (p_32323_.m_217043_().m_188501_() * 0.4f + 0.8f));
    }

    public Vector3f getProjectileShotVector(LivingEntity p_32333_, Vec3 p_32334_, float p_32335_) {
        Vec3 vec3 = p_32334_.m_82541_();
        Vec3 vec31 = vec3.m_82537_(new Vec3(0.0, 1.0, 0.0));
        if (vec31.m_82556_() <= 1.0E-7) {
            vec31 = vec3.m_82537_(p_32333_.m_20289_(1.0f));
        }
        Quaternion quaternion = new Quaternion(new Vector3f(vec31), 90.0f, true);
        Vector3f vector3f = new Vector3f(vec3);
        vector3f.m_122251_(quaternion);
        Quaternion quaternion1 = new Quaternion(vector3f, p_32335_, true);
        Vector3f vector3f1 = new Vector3f(vec3);
        vector3f1.m_122251_(quaternion1);
        return vector3f1;
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.specialAnimationTick = 45;
        } else if (p_28844_ == 11) {
            this.introAnimationTick = 45;
        } else if (p_28844_ == 33) {
            this.shootAnimationTick = this.shootAnimationLength;
        } else if (p_28844_ == 44) {
            this.biteAnimationTick = this.biteAnimationLength;
        } else if (p_28844_ == 5) {
            this.flying = true;
        } else if (p_28844_ == 6) {
            this.flying = false;
        } else if (p_28844_ == 7) {
            this.prepareFlyAnimationTick = this.prepareFlyAnimationLength;
        } else if (p_28844_ == 8) {
            this.summonTrapsAnimationTick = this.summonTrapsAnimationLength;
        } else if (p_28844_ == 36) {
            this.specialAnimationTickInShell = this.specialAnimationLengthInShell;
        } else if (p_28844_ == 12) {
            this.shootAnimationTickInShell = this.shootAnimationLengthInShell;
        } else if (p_28844_ == 10) {
            this.summonTrapsAnimationTickInShell = this.summonTrapsAnimationLengthInShell;
        } else if (p_28844_ == 37) {
            this.anvilCrushAnimationTick = this.anvilCrushAnimationLength;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public boolean m_7301_(MobEffectInstance p_34192_) {
        return p_34192_.m_19544_() == MobEffects.f_19620_ ? false : super.m_7301_(p_34192_);
    }

    public boolean m_142535_(float p_148711_, float p_148712_, DamageSource p_148713_) {
        return false;
    }

    public boolean m_5829_() {
        return this.m_6084_() && this.isInBox();
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_death", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.introAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_idle_rare", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.flying) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_spinning", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.isInBox()) {
            if (this.anvilCrushAnimationTick > 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_anvil_crush", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (this.summonTrapsAnimationTickInShell > 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_summon_traps_in_shell", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (this.shootAnimationTickInShell > 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_shoot_in_shell", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (this.isInBox()) {
                if (this.specialAnimationTickInShell > 0) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_idle_rare_in_shell", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_idle_in_shell", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
            }
        } else if (this.prepareFlyAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_enter_spin", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.summonTrapsAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_summon_traps", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.biteAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_bite", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.shootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_shoot", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.075f && event.getLimbSwingAmount() < 0.075f || this.isInBox())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.specialAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_idle_rare", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void tickDownAnimTimers() {
        if (this.specialAnimationTick > 0) {
            --this.specialAnimationTick;
        }
        if (this.introAnimationTick > 0) {
            --this.introAnimationTick;
        }
        if (this.shootAnimationTick > 0) {
            --this.shootAnimationTick;
        }
        if (this.biteAnimationTick > 0) {
            --this.biteAnimationTick;
        }
        if (this.prepareFlyAnimationTick > 0) {
            --this.prepareFlyAnimationTick;
        }
        if (this.summonTrapsAnimationTick > 0) {
            --this.summonTrapsAnimationTick;
        }
        if (this.specialAnimationTickInShell > 0) {
            --this.specialAnimationTickInShell;
        }
        if (this.shootAnimationTickInShell > 0) {
            --this.shootAnimationTickInShell;
        }
        if (this.summonTrapsAnimationTickInShell > 0) {
            --this.summonTrapsAnimationTickInShell;
        }
        if (this.anvilCrushAnimationTick > 0) {
            --this.anvilCrushAnimationTick;
        }
    }

    public void m_6043_() {
        if (!((Boolean)MutantShulkerCommonConfig.despawns.get()).booleanValue() && !((Boolean)MutantMoreGroupedOptionsCommonConfig.mutant_despawning_on.get()).booleanValue()) {
            if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
                this.m_146870_();
            } else {
                this.f_20891_ = 0;
            }
        } else {
            super.m_6043_();
        }
    }

    @Override
    public void onMutantSpawned(MobSpawnType spawnReason) {
        if (!this.f_19853_.f_46443_) {
            boolean flag = false;
            AABB aabb = this.m_20191_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)(aabb.f_82289_ + 1.0)), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                if (blockstate.m_204336_(TagInit.Blocks.UNBREAKABLE)) continue;
                flag = this.f_19853_.m_46953_(blockpos, true, (Entity)this) || flag;
            }
        }
    }

    @Override
    public void onMutated() {
        this.m_5496_((SoundEvent)SoundEventInit.MUTANT_SHULKER_ROAR.get(), 2.5f, 1.0f);
        this.introAnimationTick = 45;
        this.f_19853_.m_7605_((Entity)this, (byte)11);
        if (!this.f_19853_.f_46443_ && !this.f_19853_.f_46443_) {
            boolean flag = false;
            AABB aabb = this.m_20191_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)(aabb.f_82289_ + 1.0)), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                if (blockstate.m_204336_(TagInit.Blocks.UNBREAKABLE)) continue;
                flag = this.f_19853_.m_46953_(blockpos, true, (Entity)this) || flag;
            }
        }
        ShakeCameraEvent.shake(this.f_19853_, 80, 0.052f, this.m_20183_(), 25, CameraShakePriority.STRONG_MOB_ACTION);
    }

    protected boolean teleport() {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() - 15.0 + (double)this.f_19796_.m_188503_(30);
            double d1 = this.m_20186_() - 10.0 + (double)this.f_19796_.m_188503_(20);
            double d2 = this.m_20189_() - 15.0 + (double)this.f_19796_.m_188503_(30);
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    boolean teleportTowards(Entity p_32501_) {
        Vec3 vec3 = new Vec3(this.m_20185_() - p_32501_.m_20185_(), this.m_20227_(0.5) - p_32501_.m_20188_(), this.m_20189_() - p_32501_.m_20189_());
        vec3 = vec3.m_82541_();
        double d0 = 16.0;
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82479_ * 16.0;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vec3.f_82480_ * 16.0;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82481_ * 16.0;
        return this.teleport(d1, d2, d3);
    }

    private boolean teleport(double p_32544_, double p_32545_, double p_32546_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(p_32544_, p_32545_, p_32546_);
        while (blockpos$mutableblockpos.m_123342_() > this.f_19853_.m_141937_() && !this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60767_().m_76334_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_60767_().m_76334_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_32544_, (double)p_32545_, (double)p_32546_);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.m_20182_();
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), false);
            if (flag2) {
                this.f_19853_.m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (!this.m_20067_()) {
                    this.f_19853_.m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, (SoundEvent)SoundEventInit.MUTANT_SHULKER_TELEPORT.get(), this.m_5720_(), 1.0f, 1.0f);
                    this.m_5496_((SoundEvent)SoundEventInit.MUTANT_SHULKER_TELEPORT.get(), 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    @Override
    public boolean shouldPlayMusic() {
        if (this.f_19853_.f_46443_) {
            return BossMusicUtils.canMobPlayBossMusic((Mob)this, (Boolean)MutantShulkerClientConfig.play_battle_music.get(), this.getTargetedEntityID());
        }
        return false;
    }

    @Override
    public Music getBossMusic() {
        return MusicInit.MUTANT_THEME_MEDIUM;
    }

    class RemainStationaryGoal
    extends Goal {
        public RemainStationaryGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return MutantShulker.this.shouldBeStationary();
        }
    }

    class EnterShellGoal
    extends Goal {
        public EnterShellGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return MutantShulker.this.f_19797_ >= MutantShulker.this.nextEnterShellTime && (!MutantShulker.this.f_19853_.f_46443_ && (Boolean)MutantShulkerCommonConfig.no_target_enter_shell.get() != false && MutantShulker.this.m_5448_() == null && MutantShulker.this.m_21223_() < MutantShulker.this.m_21233_() && !MutantShulker.this.isInBox() && MutantShulker.this.f_19796_.m_188503_(((Integer)MutantShulkerCommonConfig.no_target_enter_shell_chance.get()).intValue()) == 0 || !MutantShulker.this.f_19853_.f_46443_ && MutantShulker.this.m_5448_() != null && MutantShulker.this.m_21223_() < MutantShulker.this.m_21233_() * (((Integer)MutantShulkerCommonConfig.enter_shell_health_threshold.get()).floatValue() / 100.0f) && !MutantShulker.this.isInBox() && MutantShulker.this.f_19796_.m_188503_(((Integer)MutantShulkerCommonConfig.targeting_enter_shell_chance.get()).intValue()) == 0);
        }

        public void m_8056_() {
            super.m_8056_();
            MutantShulker.this.m_216990_((SoundEvent)SoundEventInit.MUTANT_SHULKER_CLOSE.get());
            MutantShulker.this.setInBox(true);
        }
    }

    class LeaveShellGoal
    extends Goal {
        public LeaveShellGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return !MutantShulker.this.f_19853_.f_46443_ && MutantShulker.this.m_5448_() == null && MutantShulker.this.m_21223_() >= MutantShulker.this.m_21233_() && MutantShulker.this.isInBox() && MutantShulker.this.f_19796_.m_188503_(25) == 0 || !MutantShulker.this.f_19853_.f_46443_ && MutantShulker.this.m_5448_() != null && MutantShulker.this.isInBox() && ((double)MutantShulker.this.healthHealedInShell >= (Double)MutantShulkerCommonConfig.leave_shell_health_healed.get() || MutantShulker.this.m_21223_() >= MutantShulker.this.m_21233_());
        }

        public void m_8056_() {
            super.m_8056_();
            MutantShulker.this.nextEnterShellTime = MutantShulker.this.f_19797_ + (Integer)MutantShulkerCommonConfig.enter_shell_cooldown.get();
            MutantShulker.this.m_216990_((SoundEvent)SoundEventInit.MUTANT_SHULKER_OPEN.get());
            MutantShulker.this.setInBox(false);
        }
    }

    class FlyGoal
    extends Goal {
        public MutantShulker mob;
        @Nullable
        public LivingEntity target;
        public int moveDelay = 0;
        public Vec3 movement = Vec3.f_82478_;
        public int flyingFor = 0;
        public int nextUseTime;

        public FlyGoal(MutantShulker mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && this.mob.m_21223_() <= this.mob.m_21233_() * (((Integer)MutantShulkerCommonConfig.fly_health_threshold.get()).floatValue() / 100.0f) && this.mob.f_19797_ >= this.nextUseTime && this.animationsUseable() && !this.mob.flying && !this.mob.isInBox();
        }

        public boolean m_8045_() {
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && (!this.animationsUseable() || this.mob.flying);
        }

        public void m_8056_() {
            this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_SHULKER_PREPARE_FLIGHT.get(), 2.0f, 1.0f);
            this.mob.prepareFlyAnimationTick = this.mob.prepareFlyAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)7);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null) {
                if (this.mob.prepareFlyAnimationTick == this.mob.prepareFlyActionPoint) {
                    ShakeCameraEvent.shake(this.mob.f_19853_, 30, 0.015f, this.mob.m_20183_(), 15, CameraShakePriority.WEAK_MOB_ACTION);
                    this.mob.m_20256_(this.mob.m_20184_().m_82520_(0.0, 1.0, 0.0));
                } else if (this.mob.prepareFlyAnimationTick == 1) {
                    this.mob.flying = true;
                    this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)5);
                } else if (this.mob.flying) {
                    ++this.flyingFor;
                    ++this.moveDelay;
                    if (this.flyingFor >= (Integer)MutantShulkerCommonConfig.stop_flying_time.get()) {
                        this.flyingFor = 0;
                        this.mob.flying = false;
                        this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)6);
                        if (((Boolean)MutantShulkerCommonConfig.enters_shell_after_flying.get()).booleanValue() && this.mob.f_19797_ >= this.mob.nextEnterShellTime) {
                            this.mob.setInBox(true);
                        }
                        this.m_8041_();
                    }
                    ((ServerLevel)this.mob.f_19853_).m_8767_((ParticleOptions)((SimpleParticleType)ParticleTypeInit.MUTANT_SHULKER_BULLET.get()), this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), 1, 0.2, 0.2, 0.2, 0.0);
                    if (!this.mob.f_19853_.m_8055_(this.mob.m_20183_().m_7495_()).m_60795_()) {
                        this.mob.m_20256_(this.mob.m_20184_().m_82520_(0.0, 0.1, 0.0));
                    }
                    if (this.moveDelay >= 15) {
                        double x = this.target.m_20185_() - this.mob.m_20185_();
                        double y = this.target.m_20186_() + (double)(this.target.m_20206_() / 2.0f) - this.mob.m_20186_();
                        double z = this.target.m_20189_() - this.mob.m_20189_();
                        double d = Math.sqrt(x * x + y * y + z * z);
                        if (this.moveDelay == 15) {
                            this.movement = new Vec3(x / d * (Double)MutantShulkerCommonConfig.flying_movement_speed.get(), y / d * (Double)MutantShulkerCommonConfig.flying_movement_speed.get(), z / d * (Double)MutantShulkerCommonConfig.flying_movement_speed.get());
                        }
                        this.mob.m_20334_(0.0, 0.0, 0.0);
                        this.mob.m_20256_(this.mob.m_20184_().m_82549_(this.movement));
                        if (this.moveDelay >= 55) {
                            this.moveDelay = 0;
                            this.movement = Vec3.f_82478_;
                        }
                    }
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.flyingFor = 0;
            this.mob.flying = false;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)6);
            if (((Boolean)MutantShulkerCommonConfig.enters_shell_after_flying.get()).booleanValue() && this.mob.f_19797_ >= this.mob.nextEnterShellTime) {
                this.mob.setInBox(true);
            }
            this.nextUseTime = this.mob.f_19797_ + (Integer)MutantShulkerCommonConfig.fly_cooldown.get();
        }

        public boolean animationsUseable() {
            return this.mob.prepareFlyAnimationTick <= 0;
        }
    }

    class AnvilCrushAttackGoal
    extends Goal {
        public MutantShulker mob;
        @Nullable
        public LivingEntity target;

        public AnvilCrushAttackGoal(MutantShulker mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && this.mob.f_19796_.m_188503_(((Integer)MutantShulkerCommonConfig.anvil_crush_chance.get()).intValue()) == 0 && this.animationsUseable() && this.mob.isInBox();
        }

        public boolean m_8045_() {
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_216990_((SoundEvent)SoundEventInit.MUTANT_SHULKER_OPEN.get());
            this.mob.anvilCrushAnimationTick = this.mob.anvilCrushAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)37);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null) {
                this.mob.m_21563_().m_148051_((Entity)this.target);
            }
            if (this.target != null && this.mob.anvilCrushAnimationTick == this.mob.anvilCrushAnimationActionPoint) {
                this.mob.m_6021_(this.target.m_20185_(), this.target.m_20186_() + 12.5, this.target.m_20189_());
                this.mob.f_19853_.m_6263_((Player)null, this.mob.f_19854_, this.mob.f_19855_, this.mob.f_19856_, (SoundEvent)SoundEventInit.MUTANT_SHULKER_TELEPORT.get(), this.mob.m_5720_(), 1.0f, 1.0f);
                this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_SHULKER_TELEPORT.get(), 1.0f, 1.0f);
                this.mob.setAnvilAttacking(true);
            }
        }

        public boolean animationsUseable() {
            return this.mob.anvilCrushAnimationTick <= 0;
        }
    }

    class ScatterTrapsAttackGoal
    extends Goal {
        public MutantShulker mob;
        @Nullable
        public LivingEntity target;

        public ScatterTrapsAttackGoal(MutantShulker mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && this.mob.f_19796_.m_188503_(((Integer)MutantShulkerCommonConfig.scatter_traps_chance.get()).intValue()) == 0 && this.animationsUseable() && !this.mob.isInBox();
        }

        public boolean m_8045_() {
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_216990_((SoundEvent)SoundEventInit.MUTANT_SHULKER_IDLE.get());
            this.mob.summonTrapsAnimationTick = this.mob.summonTrapsAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)8);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null) {
                this.mob.m_21563_().m_148051_((Entity)this.target);
            }
            if (this.target != null && this.mob.summonTrapsAnimationTick > this.mob.summonTrapsAnimationLength - 40 && this.mob.summonTrapsAnimationTick < this.mob.summonTrapsAnimationLength - 20 && this.mob.f_19796_.m_188499_()) {
                this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_SHULKER_SHOOT_TRAP.get(), 1.0f, 1.0f);
                MutantShulkerTrap trap = (MutantShulkerTrap)((EntityType)EntityTypeInit.MUTANT_SHULKER_TRAP.get()).m_20615_(this.mob.f_19853_);
                if (this.mob != null && this.mob.m_5647_() != null) {
                    Scoreboard scoreboard = this.mob.f_19853_.m_6188_();
                    scoreboard.m_6546_(trap.m_6302_(), scoreboard.m_83489_(this.mob.m_5647_().m_5758_()));
                }
                trap.m_6027_(this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_());
                trap.m_20334_(this.mob.f_19796_.m_188583_() * 1.5, 0.6, this.mob.f_19796_.m_188583_() * 1.5);
                trap.setSpawnedByMutantShulker(true);
                trap.m_6710_(this.target);
                ((ServerLevel)this.mob.f_19853_).m_47205_((Entity)trap);
            }
        }

        public boolean animationsUseable() {
            return this.mob.summonTrapsAnimationTick <= 0;
        }
    }

    class ScatterTrapsAttackInShellGoal
    extends Goal {
        public MutantShulker mob;
        @Nullable
        public LivingEntity target;

        public ScatterTrapsAttackInShellGoal(MutantShulker mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && this.mob.f_19796_.m_188503_(((Integer)MutantShulkerCommonConfig.scatter_traps_in_shell_chance.get()).intValue()) == 0 && this.animationsUseable() && this.mob.isInBox();
        }

        public boolean m_8045_() {
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_216990_((SoundEvent)SoundEventInit.MUTANT_SHULKER_OPEN.get());
            this.mob.summonTrapsAnimationTickInShell = this.mob.summonTrapsAnimationLengthInShell;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)10);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null) {
                this.mob.m_21563_().m_148051_((Entity)this.target);
            }
            if (this.target != null && this.mob.summonTrapsAnimationTickInShell > this.mob.summonTrapsAnimationLengthInShell - 40 && this.mob.summonTrapsAnimationTickInShell < this.mob.summonTrapsAnimationLengthInShell - 20 && this.mob.f_19796_.m_188499_()) {
                this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_SHULKER_SHOOT_TRAP.get(), 1.0f, 1.0f);
                MutantShulkerTrap trap = (MutantShulkerTrap)((EntityType)EntityTypeInit.MUTANT_SHULKER_TRAP.get()).m_20615_(this.mob.f_19853_);
                if (this.mob != null && this.mob.m_5647_() != null) {
                    Scoreboard scoreboard = this.mob.f_19853_.m_6188_();
                    scoreboard.m_6546_(trap.m_6302_(), scoreboard.m_83489_(this.mob.m_5647_().m_5758_()));
                }
                trap.m_6027_(this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_());
                trap.m_20334_(this.mob.f_19796_.m_188583_() * 1.5, 0.6, this.mob.f_19796_.m_188583_() * 1.5);
                trap.setSpawnedByMutantShulker(true);
                trap.m_6710_(this.target);
                ((ServerLevel)this.mob.f_19853_).m_47205_((Entity)trap);
            }
            if (this.mob.summonTrapsAnimationTickInShell == 15) {
                this.mob.m_216990_((SoundEvent)SoundEventInit.MUTANT_SHULKER_CLOSE.get());
            }
        }

        public boolean animationsUseable() {
            return this.mob.summonTrapsAnimationTickInShell <= 0;
        }
    }

    class BiteAttackGoal
    extends Goal {
        public MutantShulker mob;
        @Nullable
        public LivingEntity target;

        public BiteAttackGoal(MutantShulker mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && (double)this.mob.m_20270_((Entity)this.target) <= (Double)MutantShulkerCommonConfig.max_bite_distance.get() && this.animationsUseable() && this.mob.m_142582_((Entity)this.target) && !this.mob.isInBox();
        }

        public boolean m_8045_() {
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_SHULKER_BITE.get(), 1.0f, 1.0f);
            this.mob.biteAnimationTick = this.mob.biteAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)44);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null && (double)this.mob.m_20270_((Entity)this.target) <= (Double)MutantShulkerCommonConfig.max_bite_damage_distance.get() && this.mob.biteAnimationTick == this.mob.biteAnimationActionPoint) {
                if (((Boolean)MutantShulkerCommonConfig.ignores_invulnerability_time.get()).booleanValue()) {
                    this.target.f_19802_ = 0;
                }
                this.target.m_6469_(DamageSourceInit.mutantShulkerBiteAttack((LivingEntity)this.mob), ((Double)MutantShulkerCommonConfig.bite_damage.get()).floatValue());
                MiscUtils.disableShield(this.target, (Integer)MutantShulkerCommonConfig.bite_disable_shield_length.get());
                double d0 = this.target.m_20185_() - this.mob.m_20185_();
                double d1 = this.target.m_20189_() - this.mob.m_20189_();
                double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                this.target.m_147240_(d0 / d2 * 2.5, 0.2, d1 / d2 * 2.5);
                ShakeCameraEvent.shake(this.mob.f_19853_, 60, 0.15f, this.mob.m_20183_(), 10, CameraShakePriority.STRONG_MOB_ACTION);
            }
        }

        public boolean animationsUseable() {
            return this.mob.biteAnimationTick <= 0;
        }
    }

    class ShootAttackGoal
    extends Goal {
        private static final Predicate<Entity> MUTANT_SHULKER_BULLET = p_33346_ -> p_33346_ instanceof MutantShulkerBullet;
        public MutantShulker mob;
        @Nullable
        public LivingEntity target;

        public ShootAttackGoal(MutantShulker mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            int nearbyBullets = this.mob.f_19853_.m_6249_((Entity)this.mob, this.mob.m_20191_().m_82400_(100.0), MUTANT_SHULKER_BULLET).size();
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && nearbyBullets <= (Integer)MutantShulkerCommonConfig.shoot_max_nearby_mutant_shulker_bullets.get() && this.mob.f_19796_.m_188503_(((Integer)MutantShulkerCommonConfig.shoot_chance.get()).intValue()) == 0 && this.animationsUseable() && !this.mob.isInBox();
        }

        public boolean m_8045_() {
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_216990_((SoundEvent)SoundEventInit.MUTANT_SHULKER_IDLE.get());
            this.mob.shootAnimationTick = this.mob.shootAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)33);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null) {
                this.mob.m_21563_().m_148051_((Entity)this.target);
            }
            if (this.target != null && this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint1) {
                MutantShulker.this.shootMutantShulkerProjectile(0.0f, null, true);
            }
            if (this.target != null && this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint2) {
                MutantShulker.this.shootMutantShulkerProjectile(-10.0f, null, true);
            }
            if (this.target != null && this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint3) {
                MutantShulker.this.shootMutantShulkerProjectile(10.0f, null, true);
            }
        }

        public boolean animationsUseable() {
            return this.mob.shootAnimationTick <= 0;
        }
    }

    class ShootAttackGoalInShell
    extends Goal {
        public MutantShulker mob;
        @Nullable
        public LivingEntity target;
        private final Predicate<Entity> MUTANT_SHULKER_BULLET = p_33346_ -> p_33346_ instanceof MutantShulkerBullet && ((MutantShulkerBullet)((Object)p_33346_)).m_37282_() == this.mob;

        public ShootAttackGoalInShell(MutantShulker mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            int nearbyBullets = this.mob.f_19853_.m_6249_((Entity)this.mob, this.mob.m_20191_().m_82400_(100.0), this.MUTANT_SHULKER_BULLET).size();
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && nearbyBullets <= (Integer)MutantShulkerCommonConfig.shoot_in_shell_max_nearby_mutant_shulker_bullets.get() && this.mob.f_19796_.m_188503_(((Integer)MutantShulkerCommonConfig.shoot_in_shell_chance.get()).intValue()) == 0 && this.animationsUseable() && this.mob.isInBox();
        }

        public boolean m_8045_() {
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_216990_((SoundEvent)SoundEventInit.MUTANT_SHULKER_OPEN.get());
            this.mob.shootAnimationTickInShell = this.mob.shootAnimationLengthInShell;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)12);
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null) {
                this.mob.m_21563_().m_148051_((Entity)this.target);
            }
            if (this.target != null && this.mob.shootAnimationTickInShell == this.mob.shootAnimationActionPointInShell) {
                MutantShulker.this.shootMutantShulkerProjectile(0.0f, null, true);
            }
            if (this.mob.shootAnimationTickInShell == 20) {
                this.mob.m_216990_((SoundEvent)SoundEventInit.MUTANT_SHULKER_CLOSE.get());
            }
        }

        public boolean animationsUseable() {
            return this.mob.shootAnimationTickInShell <= 0;
        }
    }

    static class MutantShulkerNavigation
    extends GroundPathNavigation {
        public MutantShulkerNavigation(Mob p_33379_, Level p_33380_) {
            super(p_33379_, p_33380_);
        }

        protected PathFinder m_5532_(int p_33382_) {
            this.f_26508_ = new MutantShulkerNodeEvaluator();
            return new PathFinder(this.f_26508_, p_33382_);
        }
    }

    public class MutantShulkerBodyRotationControl
    extends BodyRotationControl
    implements Control {
        private final Mob mob;
        private int headStableTime;
        private float lastStableYHeadRot;

        public MutantShulkerBodyRotationControl(Mob p_24879_) {
            super(p_24879_);
            this.mob = p_24879_;
        }

        public void m_8121_() {
            if (this.isMoving()) {
                this.mob.f_20883_ = this.mob.m_146908_();
                this.rotateHeadIfNecessary();
                this.lastStableYHeadRot = this.mob.f_20885_;
                this.headStableTime = 0;
            } else if (this.notCarryingMobPassengers()) {
                if (Math.abs(this.mob.f_20885_ - this.lastStableYHeadRot) > 15.0f) {
                    this.headStableTime = 0;
                    this.lastStableYHeadRot = this.mob.f_20885_;
                    this.rotateBodyIfNecessary();
                } else {
                    ++this.headStableTime;
                    if (this.headStableTime > 10) {
                        this.rotateHeadTowardsFront();
                    }
                }
            }
        }

        private void rotateBodyIfNecessary() {
            if (this.mob instanceof MutantShulker && ((MutantShulker)this.mob).shouldBodyMoveWithHead()) {
                this.mob.f_20883_ = Mth.m_14094_((float)this.mob.f_20883_, (float)this.mob.f_20885_, (float)75.0f);
            }
        }

        private void rotateHeadIfNecessary() {
            if (this.mob instanceof MutantShulker && ((MutantShulker)this.mob).shouldBodyMoveWithHead()) {
                this.mob.f_20885_ = Mth.m_14094_((float)this.mob.f_20885_, (float)this.mob.f_20883_, (float)75.0f);
            }
        }

        private void rotateHeadTowardsFront() {
            if (this.mob instanceof MutantShulker && ((MutantShulker)this.mob).shouldBodyMoveWithHead()) {
                int i = this.headStableTime - 10;
                float f = Mth.m_14036_((float)((float)i / 10.0f), (float)0.0f, (float)1.0f);
                float f1 = 75.0f * (1.0f - f);
                this.mob.f_20883_ = Mth.m_14094_((float)this.mob.f_20883_, (float)this.mob.f_20885_, (float)f1);
            }
        }

        private boolean notCarryingMobPassengers() {
            return !(this.mob.m_146895_() instanceof Mob);
        }

        private boolean isMoving() {
            double d1;
            double d0 = this.mob.m_20185_() - this.mob.f_19854_;
            return d0 * d0 + (d1 = this.mob.m_20189_() - this.mob.f_19856_) * d1 > 2.500000277905201E-7;
        }
    }

    static class MutantShulkerNodeEvaluator
    extends WalkNodeEvaluator {
        MutantShulkerNodeEvaluator() {
        }

        public BlockPathTypes m_8086_(BlockGetter p_77576_, int p_77577_, int p_77578_, int p_77579_) {
            if (p_77576_.m_8055_(new BlockPos(p_77577_, p_77578_, p_77579_)).m_204336_(TagInit.Blocks.MUTANT_SHULKER_WALKS_THROUGH) && ((Boolean)MutantShulkerCommonConfig.walk_griefing.get()).booleanValue() && !((Boolean)MutantMoreGroupedOptionsCommonConfig.mob_griefing_off.get()).booleanValue()) {
                return BlockPathTypes.OPEN;
            }
            return MutantShulkerNodeEvaluator.m_77604_((BlockGetter)p_77576_, (BlockPos.MutableBlockPos)new BlockPos.MutableBlockPos(p_77577_, p_77578_, p_77579_));
        }
    }
}

